/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import techguns.blocks.EnumDoorState;
import techguns.blocks.EnumDoorType;
import techguns.blocks.GenericBlock;
import techguns.events.TechgunsGuiHandler;
import techguns.items.ItemTGDoor3x3;
import techguns.tileentities.Door3x3TileEntity;

public class BlockTGDoor3x3<T extends Enum<T>>
extends GenericBlock {
    public static final PropertyBool MASTER = PropertyBool.func_177716_a((String)"master");
    public static final PropertyBool ZPLANE = PropertyBool.func_177716_a((String)"zplane");
    public static final PropertyEnum<EnumDoorState> STATE = PropertyEnum.func_177709_a((String)"state", EnumDoorState.class);
    public static final PropertyEnum<EnumDoorType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumDoorType.class);
    protected Class<T> clazz;
    protected Class clazzBlock;
    protected BlockStateContainer blockStateOverride;
    protected ItemTGDoor3x3<T> placer;
    protected static final double size = 0.375;
    protected static final double size2 = 0.25;
    protected static final AxisAlignedBB BB_X = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    protected static final AxisAlignedBB BB_Z = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    protected static final AxisAlignedBB BB_X_openTop = new AxisAlignedBB(0.0, 0.75, 0.375, 1.0, 1.0, 0.625);
    protected static final AxisAlignedBB BB_Z_openTop = new AxisAlignedBB(0.375, 0.75, 0.0, 0.625, 1.0, 1.0);
    protected static final AxisAlignedBB BB_X_openBottom = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 0.25, 0.625);
    protected static final AxisAlignedBB BB_Z_openBottom = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 0.25, 1.0);
    protected static final AxisAlignedBB BB_Z_openLeft = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 0.25);
    protected static final AxisAlignedBB BB_Z_openRight = new AxisAlignedBB(0.375, 0.0, 0.75, 0.625, 1.0, 1.0);
    protected static final AxisAlignedBB BB_X_openLeft = new AxisAlignedBB(0.0, 0.0, 0.375, 0.25, 1.0, 0.625);
    protected static final AxisAlignedBB BB_X_openRight = new AxisAlignedBB(0.75, 0.0, 0.375, 1.0, 1.0, 0.625);
    public static final int BLOCK_UPDATE_DELAY = 5;
    public static final int DOOR_OPEN_TIME = 1000;
    public static final int DOOR_AUTOCLOSE_DELAY = 5000;
    public static final int DOOR_OPEN_TICKS = 20;
    protected static Vec3i[] pos_z = new Vec3i[]{new Vec3i(0, 1, 0), new Vec3i(0, -1, 0), new Vec3i(0, 0, -1), new Vec3i(0, 0, 1), new Vec3i(0, -1, -1), new Vec3i(0, -1, 1), new Vec3i(0, 1, -1), new Vec3i(0, 1, 1)};
    protected static Vec3i[] pos_x = new Vec3i[]{new Vec3i(0, 1, 0), new Vec3i(0, -1, 0), new Vec3i(-1, 0, 0), new Vec3i(1, 0, 0), new Vec3i(-1, -1, 0), new Vec3i(1, -1, 0), new Vec3i(-1, 1, 0), new Vec3i(1, 1, 0)};
    public static AxisAlignedBB NO_COLLIDE = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public BlockTGDoor3x3(String name, Class<T> clazz, ItemTGDoor3x3<T> doorplacer) {
        super(name, Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
        this.clazz = clazz;
        this.blockStateOverride = new BlockStateContainer.Builder((Block)this).add(new IProperty[]{MASTER}).add(new IProperty[]{ZPLANE}).add(new IProperty[]{STATE}).add(new IProperty[]{TYPE}).build();
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)ZPLANE, (Comparable)Boolean.valueOf(false)).func_177226_a(STATE, (Comparable)((Object)EnumDoorState.CLOSED)).func_177226_a(TYPE, (Comparable)((Object)EnumDoorType.METAL)));
        this.placer = doorplacer;
        this.placer.setBlock(this);
        this.func_149711_c(5.0f);
    }

    @Override
    public void registerBlock(RegistryEvent.Register<Block> event) {
        super.registerBlock(event);
        GameRegistry.registerTileEntity(Door3x3TileEntity.class, (ResourceLocation)new ResourceLocation("techguns", "door3x3tileent"));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean hasTileEntity(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)MASTER);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue()) {
            return new Door3x3TileEntity();
        }
        return null;
    }

    protected BlockPos findMaster(IBlockAccess w, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue()) {
            return pos;
        }
        Vec3i[] offsets = pos_x;
        if (((Boolean)state.func_177229_b((IProperty)ZPLANE)).booleanValue()) {
            offsets = pos_z;
        }
        for (int i = 0; i < offsets.length; ++i) {
            BlockPos p = pos.func_177971_a(offsets[i]);
            IBlockState s = w.func_180495_p(p);
            if (s.func_177230_c() != this || !((Boolean)s.func_177229_b((IProperty)MASTER)).booleanValue()) continue;
            return p;
        }
        return pos;
    }

    public boolean isStateOpen(IBlockState state) {
        return state.func_177229_b(STATE) == EnumDoorState.OPENED || state.func_177229_b(STATE) == EnumDoorState.OPENING;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile instanceof Door3x3TileEntity) {
            Door3x3TileEntity door = (Door3x3TileEntity)tile;
            return state.func_177226_a(TYPE, (Comparable)((Object)EnumDoorType.values()[door.getDoorType()]));
        }
        return state;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (!this.isStateOpen(state)) {
            return this.getBBforPlane(state);
        }
        BlockPos master = this.findMaster(source, pos, state);
        IBlockState masterstate = this.func_176221_a(source.func_180495_p(master), source, master);
        EnumDoorType type = (EnumDoorType)((Object)masterstate.func_177229_b(TYPE));
        if (type == EnumDoorType.HANGAR_UP) {
            return this.getOpenBBforTypeHangarUp(state, pos, master);
        }
        if (type == EnumDoorType.HANGAR_DOWN) {
            return this.getOpenBBforTypeHangarDown(state, pos, master);
        }
        return this.getOpenBBforTypeMetal(state, pos, master);
    }

    protected AxisAlignedBB getOpenBBforTypeMetal(IBlockState state, BlockPos pos, BlockPos master) {
        if (((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue() || master.func_177956_o() >= pos.func_177956_o()) {
            if (!((Boolean)state.func_177229_b((IProperty)ZPLANE)).booleanValue()) {
                if (pos.func_177958_n() < master.func_177958_n()) {
                    return BB_X_openLeft;
                }
                if (pos.func_177958_n() > master.func_177958_n()) {
                    return BB_X_openRight;
                }
            } else {
                if (pos.func_177952_p() < master.func_177952_p()) {
                    return BB_Z_openLeft;
                }
                if (pos.func_177952_p() > master.func_177952_p()) {
                    return BB_Z_openRight;
                }
            }
            return NO_COLLIDE;
        }
        if (!((Boolean)state.func_177229_b((IProperty)ZPLANE)).booleanValue()) {
            return BB_X_openTop;
        }
        return BB_Z_openTop;
    }

    protected AxisAlignedBB getOpenBBforTypeHangarUp(IBlockState state, BlockPos pos, BlockPos master) {
        if (((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue() || master.func_177956_o() >= pos.func_177956_o()) {
            return NO_COLLIDE;
        }
        if (!((Boolean)state.func_177229_b((IProperty)ZPLANE)).booleanValue()) {
            return BB_X_openTop;
        }
        return BB_Z_openTop;
    }

    protected AxisAlignedBB getOpenBBforTypeHangarDown(IBlockState state, BlockPos pos, BlockPos master) {
        if (((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue() || master.func_177956_o() <= pos.func_177956_o()) {
            return NO_COLLIDE;
        }
        if (!((Boolean)state.func_177229_b((IProperty)ZPLANE)).booleanValue()) {
            return BB_X_openBottom;
        }
        return BB_Z_openBottom;
    }

    protected AxisAlignedBB getBBforPlane(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)ZPLANE)).booleanValue()) {
            return BB_X;
        }
        return BB_Z;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        if (this.isStateOpen(blockState)) {
            return field_185506_k;
        }
        return this.getBBforPlane(blockState);
    }

    private int getCloseSound() {
        return this.field_149764_J == Material.field_151573_f ? 1011 : 1012;
    }

    private int getOpenSound() {
        return this.field_149764_J == Material.field_151573_f ? 1005 : 1006;
    }

    public EnumDoorState getNextOpenState(EnumDoorState current) {
        switch (current) {
            case CLOSED: {
                return EnumDoorState.OPENING;
            }
            case OPENED: {
                return EnumDoorState.CLOSING;
            }
            case OPENING: {
                return EnumDoorState.OPENED;
            }
        }
        return EnumDoorState.CLOSED;
    }

    public void toggleState(World w, BlockPos masterPos) {
        this.toggleState(w, masterPos, true);
    }

    public void toggleState(World w, BlockPos masterPos, boolean checkNeighbours) {
        IBlockState masterstate = w.func_180495_p(masterPos);
        EnumDoorState nextState = this.getNextOpenState((EnumDoorState)((Object)masterstate.func_177229_b(STATE)));
        Vec3i[] offsets = pos_x;
        if (((Boolean)masterstate.func_177229_b((IProperty)ZPLANE)).booleanValue()) {
            offsets = pos_z;
        }
        for (int i = 0; i < offsets.length; ++i) {
            BlockPos p = masterPos.func_177971_a(offsets[i]);
            this.setOpenedStateForBlock(w, p, nextState);
        }
        this.setOpenedStateForBlock(w, masterPos, nextState);
        w.func_180498_a((EntityPlayer)null, this.getOpenSound(), masterPos, 0);
        TileEntity tile = w.func_175625_s(masterPos);
        if (tile != null && tile instanceof Door3x3TileEntity) {
            Door3x3TileEntity door = (Door3x3TileEntity)tile;
            if (!w.field_72995_K) {
                door.changeStateServerSide();
                EnumDoorType type = (EnumDoorType)((Object)masterstate.func_185899_b((IBlockAccess)w, masterPos).func_177229_b(TYPE));
                if (checkNeighbours && (type == EnumDoorType.HANGAR_DOWN || type == EnumDoorType.HANGAR_UP)) {
                    this.checkOpenNeighbours(w, masterPos, masterstate.func_185899_b((IBlockAccess)w, masterPos), door);
                }
                if (nextState == EnumDoorState.OPENING || nextState == EnumDoorState.CLOSING) {
                    w.func_180497_b(masterPos, (Block)this, 19, 0);
                } else if (door.isAutoClose() && nextState == EnumDoorState.OPENED) {
                    w.func_180497_b(masterPos, (Block)this, 5, 0);
                }
                door.setLastStateChangeTime(System.currentTimeMillis());
            } else {
                door.setLastStateChangeTime(System.currentTimeMillis());
            }
        }
    }

    public void checkOpenNeighbours(World w, BlockPos masterPos, IBlockState masterstate, Door3x3TileEntity tile) {
        boolean zplane = (Boolean)masterstate.func_177229_b((IProperty)ZPLANE);
        BlockPos pos = null;
        block0: for (int i = 0; i < 2; ++i) {
            for (int z = 3; z <= 9; z += 3) {
                pos = new BlockPos((Vec3i)masterPos);
                pos = zplane ? (i == 0 ? pos.func_177982_a(0, 0, -z) : pos.func_177982_a(0, 0, z)) : (i == 0 ? pos.func_177982_a(-z, 0, 0) : pos.func_177982_a(z, 0, 0));
                if (!this.checkBlockAndToggleState(w, pos, masterstate)) continue block0;
            }
        }
        int y = masterstate.func_177229_b(TYPE) == EnumDoorType.HANGAR_UP ? -3 : 3;
        BlockPos otherMaster = masterPos.func_177982_a(0, y, 0);
        if (this.checkBlockAndToggleState(w, otherMaster, masterstate)) {
            block2: for (int i = 0; i < 2; ++i) {
                for (int z = 3; z <= 9; z += 3) {
                    pos = new BlockPos((Vec3i)otherMaster);
                    pos = zplane ? (i == 0 ? pos.func_177982_a(0, 0, -z) : pos.func_177982_a(0, 0, z)) : (i == 0 ? pos.func_177982_a(-z, 0, 0) : pos.func_177982_a(z, 0, 0));
                    if (!this.checkBlockAndToggleState(w, pos, masterstate)) continue block2;
                }
            }
        }
    }

    protected boolean checkBlockAndToggleState(World w, BlockPos pos, IBlockState masterstate) {
        Block b;
        IBlockState state = w.func_180495_p(pos);
        if (this.isMatchingDoorType(masterstate, state = state.func_185899_b((IBlockAccess)w, pos)) && (b = state.func_177230_c()).getClass() == this.getClass()) {
            BlockTGDoor3x3 d = (BlockTGDoor3x3)this.getClass().cast(b);
            d.toggleState(w, pos, false);
            return true;
        }
        return false;
    }

    protected boolean isMatchingDoorType(IBlockState master, IBlockState other) {
        if (master == other) {
            return true;
        }
        EnumDoorType type = (EnumDoorType)((Object)master.func_177229_b(TYPE));
        if (type == EnumDoorType.HANGAR_DOWN || type == EnumDoorType.HANGAR_UP) {
            return master.func_177226_a(TYPE, (Comparable)((Object)EnumDoorType.HANGAR_DOWN)) == other || master.func_177226_a(TYPE, (Comparable)((Object)EnumDoorType.HANGAR_UP)) == other;
        }
        return false;
    }

    public void setOpenedStateForBlock(World w, BlockPos p, EnumDoorState doorstate) {
        IBlockState state = w.func_180495_p(p);
        if (state.func_177230_c() == this) {
            IBlockState newstate = state.func_177226_a(STATE, (Comparable)((Object)doorstate));
            w.func_180501_a(p, newstate, 3);
        }
    }

    public BlockStateContainer func_176194_O() {
        return this.blockStateOverride;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(STATE, (Comparable)((Object)EnumDoorState.values()[meta & 3])).func_177226_a((IProperty)ZPLANE, (Comparable)Boolean.valueOf((meta & 4) > 0)).func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue()) {
            meta += 8;
        }
        if (((Boolean)state.func_177229_b((IProperty)ZPLANE)).booleanValue()) {
            meta += 4;
        }
        return meta += ((EnumDoorState)((Object)state.func_177229_b(STATE))).ordinal();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.placer;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        BlockPos masterPos = this.findMaster((IBlockAccess)world, pos, state);
        TileEntity tile = world.func_175625_s(masterPos);
        if (tile != null && tile instanceof Door3x3TileEntity) {
            Door3x3TileEntity door = (Door3x3TileEntity)tile;
            return new ItemStack(this.placer, 1, door.getDoorType());
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        NonNullList drops;
        float chance;
        if (player.field_71075_bZ.field_75098_d || worldIn.field_72995_K) {
            return;
        }
        ItemStack drop = ItemStack.field_190927_a;
        BlockPos masterPos = this.findMaster((IBlockAccess)worldIn, pos, state);
        TileEntity tile = worldIn.func_175625_s(masterPos);
        if (tile != null && tile instanceof Door3x3TileEntity) {
            Door3x3TileEntity door = (Door3x3TileEntity)tile;
            drop = new ItemStack(this.placer, 1, door.getDoorType());
        }
        if (!drop.func_190926_b() && !worldIn.restoringBlockSnapshots && ((chance = ForgeEventFactory.fireBlockHarvesting((List)(drops = NonNullList.func_191197_a((int)1, (Object)drop)), (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)player)) >= 1.0f || worldIn.field_73012_v.nextFloat() <= chance)) {
            BlockTGDoor3x3.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)drop);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public boolean canPlaceDoor(World worldIn, BlockPos pos, EnumFacing lookdirection) {
        int xmin = 0;
        int xmax = 1;
        int zmin = 0;
        int zmax = 1;
        if (lookdirection == EnumFacing.NORTH || lookdirection == EnumFacing.SOUTH) {
            xmin = -1;
            xmax = 2;
        } else {
            zmin = -1;
            zmax = 2;
        }
        for (int x = xmin; x < xmax; ++x) {
            for (int y = 0; y < 3; ++y) {
                for (int z = zmin; z < zmax; ++z) {
                    if (this.func_176196_c(worldIn, pos.func_177982_a(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Class<T> getEnumClazz() {
        return this.clazz;
    }

    protected void breakSlave(World w, BlockPos p) {
        IBlockState state = w.func_180495_p(p);
        if (state.func_177230_c() == this) {
            w.func_175698_g(p);
        }
    }

    protected void checkBreakMaster(World w, BlockPos p) {
        IBlockState state = w.func_180495_p(p);
        if (state.func_177230_c() == this && ((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue()) {
            w.func_175698_g(p);
        }
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        return this.isStateOpen(state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Door3x3TileEntity door;
        BlockPos master = this.findMaster((IBlockAccess)worldIn, pos, state);
        TileEntity tile = worldIn.func_175625_s(master);
        if (tile != null && tile instanceof Door3x3TileEntity && (door = (Door3x3TileEntity)tile).isUseableByPlayer(playerIn)) {
            if (playerIn.func_70093_af()) {
                boolean wrenchLeft;
                boolean wrenchRight = !playerIn.func_184614_ca().func_190926_b() && playerIn.func_184614_ca().func_77973_b().getToolClasses(playerIn.func_184614_ca()).contains("wrench");
                boolean bl = wrenchLeft = !playerIn.func_184614_ca().func_190926_b() && playerIn.func_184614_ca().func_77973_b().getToolClasses(playerIn.func_184614_ca()).contains("wrench");
                if (wrenchRight || wrenchLeft) {
                    if (!worldIn.field_72995_K) {
                        TechgunsGuiHandler.openGuiForPlayer(playerIn, tile);
                    }
                } else if (door.isOpenWithRightClick()) {
                    this.toggleState(worldIn, master);
                }
            } else if (door.isOpenWithRightClick()) {
                this.toggleState(worldIn, master);
            }
        }
        return true;
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean isPowered(World w, BlockPos masterPos) {
        IBlockState masterstate = w.func_180495_p(masterPos);
        Vec3i[] offsets = pos_x;
        if (((Boolean)masterstate.func_177229_b((IProperty)ZPLANE)).booleanValue()) {
            offsets = pos_z;
        }
        for (int i = 0; i < offsets.length; ++i) {
            BlockPos p = masterPos.func_177971_a(offsets[i]);
            if (!w.func_175640_z(p)) continue;
            return true;
        }
        return false;
    }

    public void updateRedstoneState(IBlockAccess world, BlockPos masterPos) {
        Door3x3TileEntity door;
        TileEntity tile = world.func_175625_s(masterPos);
        if (tile != null && tile instanceof Door3x3TileEntity && (door = (Door3x3TileEntity)tile).isRedstoneMode() && door.getRedstoneBehaviour() != 0) {
            IBlockState masterstate = world.func_180495_p(masterPos);
            boolean powered = this.isPowered(door.func_145831_w(), masterPos);
            if (door.getRedstoneBehaviour() == 1) {
                if (powered && masterstate.func_177229_b(STATE) == EnumDoorState.CLOSED || !powered && masterstate.func_177229_b(STATE) == EnumDoorState.OPENED) {
                    this.toggleState(door.func_145831_w(), masterPos);
                }
            } else if (door.getRedstoneBehaviour() == 2 && (!powered && masterstate.func_177229_b(STATE) == EnumDoorState.CLOSED || powered && masterstate.func_177229_b(STATE) == EnumDoorState.OPENED)) {
                this.toggleState(door.func_145831_w(), masterPos);
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue()) {
            BlockPos masterpos = this.findMaster((IBlockAccess)world, pos, state);
            this.updateRedstoneState((IBlockAccess)world, masterpos);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue()) {
            this.breakSlave(worldIn, pos.func_177984_a());
            this.breakSlave(worldIn, pos.func_177977_b());
            if (((Boolean)state.func_177229_b((IProperty)ZPLANE)).booleanValue()) {
                this.breakSlave(worldIn, pos.func_177978_c());
                this.breakSlave(worldIn, pos.func_177978_c().func_177984_a());
                this.breakSlave(worldIn, pos.func_177978_c().func_177977_b());
                this.breakSlave(worldIn, pos.func_177968_d());
                this.breakSlave(worldIn, pos.func_177968_d().func_177984_a());
                this.breakSlave(worldIn, pos.func_177968_d().func_177977_b());
            } else {
                this.breakSlave(worldIn, pos.func_177974_f());
                this.breakSlave(worldIn, pos.func_177974_f().func_177984_a());
                this.breakSlave(worldIn, pos.func_177974_f().func_177977_b());
                this.breakSlave(worldIn, pos.func_177976_e());
                this.breakSlave(worldIn, pos.func_177976_e().func_177984_a());
                this.breakSlave(worldIn, pos.func_177976_e().func_177977_b());
            }
        } else {
            this.checkBreakMaster(worldIn, pos.func_177984_a());
            this.checkBreakMaster(worldIn, pos.func_177977_b());
            if (((Boolean)state.func_177229_b((IProperty)ZPLANE)).booleanValue()) {
                this.checkBreakMaster(worldIn, pos.func_177978_c());
                this.checkBreakMaster(worldIn, pos.func_177978_c().func_177984_a());
                this.checkBreakMaster(worldIn, pos.func_177978_c().func_177977_b());
                this.checkBreakMaster(worldIn, pos.func_177968_d());
                this.checkBreakMaster(worldIn, pos.func_177968_d().func_177984_a());
                this.checkBreakMaster(worldIn, pos.func_177968_d().func_177977_b());
            } else {
                this.checkBreakMaster(worldIn, pos.func_177974_f());
                this.checkBreakMaster(worldIn, pos.func_177974_f().func_177984_a());
                this.checkBreakMaster(worldIn, pos.func_177974_f().func_177977_b());
                this.checkBreakMaster(worldIn, pos.func_177976_e());
                this.checkBreakMaster(worldIn, pos.func_177976_e().func_177984_a());
                this.checkBreakMaster(worldIn, pos.func_177976_e().func_177977_b());
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        if (rot == Rotation.COUNTERCLOCKWISE_90 || rot == Rotation.CLOCKWISE_90) {
            return state.func_177226_a((IProperty)ZPLANE, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((IProperty)ZPLANE) == false));
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state;
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        Door3x3TileEntity door;
        TileEntity tile;
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue() && (tile = worldIn.func_175625_s(pos)) != null && tile instanceof Door3x3TileEntity && (door = (Door3x3TileEntity)tile).isPlayerDetector()) {
            worldIn.func_180497_b(pos, (Block)this, 5, 0);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.field_72995_K || state.func_177230_c() != this || !((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue()) {
            return;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile instanceof Door3x3TileEntity) {
            boolean closedstate;
            Door3x3TileEntity door = (Door3x3TileEntity)tile;
            boolean openstate = state.func_177229_b(STATE) == EnumDoorState.OPENED;
            boolean bl = closedstate = state.func_177229_b(STATE) == EnumDoorState.CLOSED;
            if (!openstate && !closedstate) {
                worldIn.func_180497_b(pos, (Block)this, 1, 0);
                if (System.currentTimeMillis() - door.getLastStateChangeTime() > 1000L) {
                    this.toggleState(worldIn, pos);
                }
            } else if (door.getDoormode() == 0) {
                if (door.isAutoClose() && openstate) {
                    if (door.checkAutoCloseDelay()) {
                        this.toggleState(worldIn, pos);
                    }
                    worldIn.func_180497_b(pos, (Block)this, 5, 0);
                }
            } else if (door.getDoormode() == 2) {
                boolean open = this.checkOpenForNearPlayers(worldIn, door, pos);
                if (open && closedstate) {
                    this.toggleState(worldIn, pos);
                } else if (!open && openstate && door.checkPlayerSensorAutoCloseDelay()) {
                    this.toggleState(worldIn, pos);
                }
                worldIn.func_180497_b(pos, (Block)this, 5, 0);
            }
        }
    }

    protected boolean checkOpenForNearPlayers(World w, Door3x3TileEntity door, BlockPos masterPos) {
        AxisAlignedBB bb = new AxisAlignedBB(masterPos).func_72314_b(2.0, 1.0, 2.0);
        List nearbyPlayers = w.func_72872_a(EntityPlayer.class, bb);
        for (EntityPlayer ply : nearbyPlayers) {
            if (!door.isUseableByPlayer(ply)) continue;
            return true;
        }
        return false;
    }
}

