/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui.misc;

import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class SelectImageScreen
extends ButtonListBaseScreen {
    private final ImageConfig imageConfig;
    private final ConfigCallback callback;
    private final List<ResourceLocation> images;

    public SelectImageScreen(ImageConfig i, ConfigCallback c) {
        this.imageConfig = i;
        this.callback = c;
        this.setTitle((Component)new TextComponent("Select Image"));
        this.setHasSearchBox(true);
        this.focus();
        this.setBorder(1, 1, 1);
        this.images = new ArrayList<ResourceLocation>();
        StringUtils.ignoreResourceLocationErrors = true;
        Collection<Object> textures = Collections.emptyList();
        try {
            textures = Minecraft.m_91087_().m_91098_().m_6540_("textures", t -> t.endsWith(".png"));
        }
        catch (Exception ex) {
            FTBLibrary.LOGGER.error("A mod has broken resource preventing this list from loading: " + ex);
        }
        StringUtils.ignoreResourceLocationErrors = false;
        for (ResourceLocation resourceLocation : textures) {
            if (!ResourceLocation.m_135830_((String)resourceLocation.toString())) {
                FTBLibrary.LOGGER.warn("Image " + resourceLocation + " has invalid path! Report this to author of '" + resourceLocation.m_135827_() + "'!");
                continue;
            }
            if (!this.isValidImage(resourceLocation)) continue;
            this.images.add(resourceLocation);
        }
        this.images.sort(null);
    }

    public boolean allowNone() {
        return true;
    }

    public boolean isValidImage(ResourceLocation id) {
        return !id.m_135815_().startsWith("textures/font/");
    }

    @Override
    public void addButtons(Panel panel) {
        if (this.allowNone()) {
            panel.add(new SimpleTextButton(panel, (Component)new TextComponent("None"), Icon.EMPTY){

                @Override
                public void onClicked(MouseButton mouseButton) {
                    this.playClickSound();
                    SelectImageScreen.this.imageConfig.setCurrentValue("");
                    SelectImageScreen.this.callback.save(true);
                }
            });
        }
        for (final ResourceLocation res : this.images) {
            panel.add(new SimpleTextButton(panel, (Component)new TextComponent("").m_7220_((Component)new TextComponent(res.m_135827_()).m_130940_(ChatFormatting.GOLD)).m_130946_(":").m_7220_((Component)new TextComponent(res.m_135815_().substring(9, res.m_135815_().length() - 4)).m_130940_(ChatFormatting.YELLOW)), Icon.getIcon(res.toString())){

                @Override
                public void onClicked(MouseButton mouseButton) {
                    this.playClickSound();
                    SelectImageScreen.this.imageConfig.setCurrentValue(res.toString());
                    SelectImageScreen.this.callback.save(true);
                }
            });
        }
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.callback.save(false);
            return false;
        }
        return false;
    }
}

