/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.integration;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import dev.ftb.mods.ftblibrary.config.ui.ItemSearchMode;
import dev.ftb.mods.ftblibrary.config.ui.SelectItemStackScreen;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButton;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonGroup;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonManager;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.favorites.SystemFavoriteEntryProvider;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class REIIntegration
implements REIClientPlugin {
    public static final ResourceLocation ID = new ResourceLocation("ftblibrary", "sidebar_button");
    private static final ItemSearchMode REI_ITEMS = new ItemSearchMode(){

        @Override
        public Icon getIcon() {
            return ItemIcon.getItemIcon(Items.f_151079_);
        }

        @Override
        public MutableComponent getDisplayName() {
            return new TranslatableComponent("ftblibrary.select_item.list_mode.rei");
        }

        @Override
        public Collection<ItemStack> getAllItems() {
            return CollectionUtils.filterAndMap((Iterable)EntryRegistry.getInstance().getPreFilteredList(), stack -> stack.getType().equals(VanillaEntryTypes.ITEM), stack -> (ItemStack)stack.castValue());
        }
    };

    public void registerFavorites(FavoriteEntryType.Registry registry) {
        registry.register(ID, (FavoriteEntryType)SidebarButtonType.INSTANCE);
        registry.registerSystemFavorites((SystemFavoriteEntryProvider)new SystemFavoriteEntryProvider<FavoriteEntry>(){

            public List<FavoriteEntry> provide() {
                ArrayList<FavoriteEntry> entries = new ArrayList<FavoriteEntry>();
                for (SidebarButtonGroup group : SidebarButtonManager.INSTANCE.groups) {
                    for (SidebarButton button : group.getButtons()) {
                        entries.add(new SidebarButtonEntry(button));
                    }
                }
                return entries;
            }

            public long updateInterval() {
                return 2000L;
            }
        });
    }

    static {
        SelectItemStackScreen.modes.add(0, REI_ITEMS);
    }

    private static enum SidebarButtonType implements FavoriteEntryType<SidebarButtonEntry>
    {
        INSTANCE;


        public CompoundTag save(SidebarButtonEntry entry, CompoundTag tag) {
            tag.m_128359_("id", entry.button.id.toString());
            tag.m_128359_("json", new Gson().toJson((JsonElement)entry.button.json));
            return tag;
        }

        public DataResult<SidebarButtonEntry> read(CompoundTag object) {
            ResourceLocation id = new ResourceLocation(object.m_128461_("id"));
            JsonObject json = (JsonObject)JsonParser.parseString((String)object.m_128461_("json"));
            return DataResult.success((Object)((Object)new SidebarButtonEntry(new SidebarButton(id, null, json))), (Lifecycle)Lifecycle.stable());
        }

        public DataResult<SidebarButtonEntry> fromArgs(Object ... args) {
            if (args.length == 0) {
                return DataResult.error((String)"Cannot create SidebarButtonEntry from empty args!");
            }
            if (!(args[0] instanceof ResourceLocation)) {
                return DataResult.error((String)"Creation of SidebarButtonEntry from args expected ResourceLocation as the first argument!");
            }
            if (!(args[1] instanceof SidebarButton) && !(args[1] instanceof JsonObject)) {
                return DataResult.error((String)"Creation of SidebarButtonEntry from args expected SidebarButton or JsonObject as the second argument!");
            }
            return DataResult.success((Object)((Object)new SidebarButtonEntry(args[1] instanceof SidebarButton ? (SidebarButton)args[1] : new SidebarButton((ResourceLocation)args[0], null, (JsonObject)args[1]))), (Lifecycle)Lifecycle.stable());
        }
    }

    private static class SidebarButtonEntry
    extends FavoriteEntry {
        private final SidebarButton button;

        public SidebarButtonEntry(SidebarButton button) {
            this.button = button;
        }

        public boolean isInvalid() {
            for (SidebarButtonGroup group : SidebarButtonManager.INSTANCE.groups) {
                for (SidebarButton groupButton : group.getButtons()) {
                    if (!groupButton.id.equals((Object)this.button.id) || !groupButton.isActuallyVisible()) continue;
                    return false;
                }
            }
            return true;
        }

        public Renderer getRenderer(boolean showcase) {
            return new Renderer(){

                public void render(PoseStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                    GuiHelper.setupDrawing();
                    button.getIcon().draw(matrices, bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
                }

                @Nullable
                public Tooltip getTooltip(Point mouse) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(I18n.m_118938_((String)button.getLangKey(), (Object[])new Object[0]));
                    if (button.getTooltipHandler() != null) {
                        button.getTooltipHandler().accept(list);
                    }
                    return Tooltip.create((Point)mouse, (Collection)CollectionUtils.map(list, ImmutableTextComponent::new));
                }

                public int getZ() {
                    return 0;
                }

                public void setZ(int z) {
                }
            };
        }

        public boolean doAction(int button) {
            this.button.onClicked(Screen.m_96638_());
            return true;
        }

        public long hashIgnoreAmount() {
            return this.button.id.hashCode();
        }

        public FavoriteEntry copy() {
            return new SidebarButtonEntry(new SidebarButton(this.button.id, null, this.button.json));
        }

        public ResourceLocation getType() {
            return ID;
        }

        public boolean isSame(FavoriteEntry other) {
            if (other instanceof SidebarButtonEntry) {
                return ((SidebarButtonEntry)other).button.id.equals((Object)this.button.id);
            }
            return false;
        }
    }
}

