/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config;

import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionResult;

public enum Tristate {
    FALSE("false", "false", InteractionResult.FAIL, Color4I.rgb(13969460), 1, Icons.ACCEPT_GRAY),
    TRUE("true", "true", InteractionResult.SUCCESS, Color4I.rgb(0x33AA33), 0, Icons.ACCEPT),
    DEFAULT("default", "Default", InteractionResult.PASS, Color4I.rgb(38143), 2, Icons.SETTINGS);

    public static final Tristate[] VALUES;
    public static final NameMap<Tristate> NAME_MAP;
    public final String name;
    public final String displayName;
    public final InteractionResult result;
    public final Color4I color;
    private final int opposite;
    public final Icon icon;

    public static Tristate read(CompoundTag nbt, String key) {
        return nbt.m_128441_(key) ? (nbt.m_128471_(key) ? TRUE : FALSE) : DEFAULT;
    }

    public static Tristate read(FriendlyByteBuf buffer) {
        return VALUES[buffer.readUnsignedByte()];
    }

    private Tristate(String n2, String dn, InteractionResult r, Color4I c, int o, Icon i) {
        this.name = n2;
        this.displayName = dn;
        this.result = r;
        this.color = c;
        this.opposite = o;
        this.icon = i;
    }

    public boolean isTrue() {
        return this == TRUE;
    }

    public boolean isFalse() {
        return this == FALSE;
    }

    public boolean isDefault() {
        return this == DEFAULT;
    }

    public boolean get(boolean def) {
        return this.isDefault() ? def : this.isTrue();
    }

    public Tristate getOpposite() {
        return NAME_MAP.get(this.opposite);
    }

    public String toString() {
        return this.name;
    }

    public void write(CompoundTag nbt, String key) {
        if (!this.isDefault()) {
            nbt.m_128379_(key, this.isTrue());
        }
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeByte(this.ordinal());
    }

    static {
        VALUES = Tristate.values();
        NAME_MAP = NameMap.of(DEFAULT, VALUES).id(v -> v.name).name(v -> new TextComponent(v.displayName)).color(v -> v.color).icon(v -> v.icon).create();
    }
}

