/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.core.features.ActivityState;
import appeng.core.features.IStackSrc;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemStackSrc
implements IStackSrc {
    private final Item item;
    private final int damage;
    private final boolean enabled;

    public ItemStackSrc(Item item, int damage, ActivityState state) {
        Preconditions.checkNotNull((Object)item);
        Preconditions.checkArgument((damage >= 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)((Object)state));
        Preconditions.checkArgument((state == ActivityState.Enabled || state == ActivityState.Disabled ? 1 : 0) != 0);
        this.item = item;
        this.damage = damage;
        this.enabled = state == ActivityState.Enabled;
    }

    @Override
    @Nullable
    public ItemStack stack(int i) {
        return new ItemStack(this.item, i, this.damage);
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

