/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.handler;

import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.ItemModBook;
import vazkii.patchouli.common.util.ItemStackUtil;

public class BookRightClickHandler {
    @SubscribeEvent
    public static void onRenderHUD(RenderGameOverlayEvent.Post event) {
        BookEntry entry;
        Pair<BookEntry, Integer> hover;
        Book book;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack bookStack = player.func_184614_ca();
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && mc.field_71462_r == null && (book = BookRightClickHandler.getBookFromStack(bookStack)) != null && (hover = BookRightClickHandler.getHoveredEntry(book)) != null && !(entry = (BookEntry)hover.getLeft()).isLocked()) {
            ScaledResolution res = event.getResolution();
            int x = res.func_78326_a() / 2 + 3;
            int y = res.func_78328_b() / 2 + 3;
            entry.getIcon().render(x, y);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
            mc.func_175599_af().func_180450_b(bookStack, (x + 8) * 2, (y + 8) * 2);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
            mc.field_71466_p.func_175063_a(entry.getName(), (float)(x + 18), (float)(y + 3), 0xFFFFFF);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)1.0f);
            String s = I18n.func_135052_a((String)("patchouli.gui.lexicon." + (player.func_70093_af() ? "view" : "sneak")), (Object[])new Object[0]);
            mc.field_71466_p.func_175063_a(TextFormatting.ITALIC + s, (float)(x + 18) / 0.75f, (float)(y + 14) / 0.75f, 0xBBBBBB);
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        BookEntry entry;
        Pair<BookEntry, Integer> hover;
        Book book;
        EntityPlayer player = event.getEntityPlayer();
        ItemStack bookStack = player.func_184614_ca();
        if (event.getWorld().field_72995_K && player.func_70093_af() && (book = BookRightClickHandler.getBookFromStack(bookStack)) != null && (hover = BookRightClickHandler.getHoveredEntry(book)) != null && !(entry = (BookEntry)hover.getLeft()).isLocked()) {
            GuiBookEntry currEntry;
            int page = (Integer)hover.getRight();
            GuiBook curr = book.contents.getCurrentGui();
            book.contents.currentGui = new GuiBookEntry(book, entry, page);
            player.func_184609_a(EnumHand.MAIN_HAND);
            if (curr instanceof GuiBookEntry && (currEntry = (GuiBookEntry)curr).getEntry() == entry && currEntry.getPage() == page) {
                return;
            }
            book.contents.guiStack.push(curr);
        }
    }

    private static Book getBookFromStack(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemModBook) {
            return ItemModBook.getBook(stack);
        }
        Collection<Book> books = BookRegistry.INSTANCE.books.values();
        for (Book b : books) {
            if (!b.getBookItem().func_77969_a(stack)) continue;
            return b;
        }
        return null;
    }

    private static Pair<BookEntry, Integer> getHoveredEntry(Book book) {
        BlockPos pos;
        IBlockState state;
        Block block;
        ItemStack picked;
        Minecraft mc = Minecraft.func_71410_x();
        RayTraceResult res = mc.field_71476_x;
        if (res != null && res.field_72313_a == RayTraceResult.Type.BLOCK && !(picked = (block = (state = mc.field_71441_e.func_180495_p(pos = res.func_178782_a())).func_177230_c()).getPickBlock(state, res, (World)mc.field_71441_e, pos, (EntityPlayer)mc.field_71439_g)).func_190926_b()) {
            return book.contents.recipeMappings.get(ItemStackUtil.wrapStack(picked));
        }
        return null;
    }
}

