/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tier;

import mekanism.common.config.MekanismConfig;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.ITier;

public enum TubeTier implements ITier
{
    BASIC(256, 64),
    ADVANCED(1024, 256),
    ELITE(4096, 1024),
    ULTIMATE(16384, 4096);

    private final int baseCapacity;
    private final int basePull;
    private final BaseTier baseTier;

    private TubeTier(int capacity, int pullAmount) {
        this.baseCapacity = capacity;
        this.basePull = pullAmount;
        this.baseTier = BaseTier.values()[this.ordinal()];
    }

    public static TubeTier get(BaseTier tier) {
        for (TubeTier transmitter : TubeTier.values()) {
            if (transmitter.getBaseTier() != tier) continue;
            return transmitter;
        }
        return BASIC;
    }

    @Override
    public BaseTier getBaseTier() {
        return this.baseTier;
    }

    public int getTubeCapacity() {
        return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).TubeCapacity.val();
    }

    public int getTubePullAmount() {
        return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).TubePullAmount.val();
    }

    public int getBaseCapacity() {
        return this.baseCapacity;
    }

    public int getBasePull() {
        return this.basePull;
    }
}

