/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.handlers;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import mekanism.api.gas.Gas;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.crafttweaker.gas.IGasStack;
import mekanism.common.integration.crafttweaker.helpers.GasHelper;
import mekanism.common.integration.crafttweaker.helpers.IngredientHelper;
import mekanism.common.integration.crafttweaker.util.AddMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.IngredientWrapper;
import mekanism.common.integration.crafttweaker.util.RemoveAllMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.RemoveMekanismRecipe;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.machines.PurificationRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.purification")
@ZenRegister
public class Purification {
    public static final String NAME = "Mekanism Purification";

    @ZenMethod
    public static void addRecipe(IIngredient ingredientInput, IItemStack itemOutput) {
        if (IngredientHelper.checkNotNull(NAME, new IIngredient[]{ingredientInput, itemOutput})) {
            ItemStack output = CraftTweakerMC.getItemStack((IItemStack)itemOutput);
            ArrayList<PurificationRecipe> recipes = new ArrayList<PurificationRecipe>();
            for (ItemStack stack : CraftTweakerMC.getIngredient((IIngredient)ingredientInput).func_193365_a()) {
                recipes.add(new PurificationRecipe(stack, output));
            }
            CrafttweakerIntegration.LATE_ADDITIONS.add(new AddMekanismRecipe<AdvancedMachineInput, ItemStackOutput, PurificationRecipe>(NAME, RecipeHandler.Recipe.PURIFICATION_CHAMBER, recipes));
        }
    }

    @ZenMethod
    public static void addRecipe(IIngredient ingredientInput, IGasStack gasInput, IItemStack itemOutput) {
        if (IngredientHelper.checkNotNull(NAME, new IIngredient[]{ingredientInput, gasInput, itemOutput})) {
            Gas gas = GasHelper.toGas(gasInput).getGas();
            ItemStackOutput output = new ItemStackOutput(CraftTweakerMC.getItemStack((IItemStack)itemOutput));
            ArrayList<PurificationRecipe> recipes = new ArrayList<PurificationRecipe>();
            for (ItemStack stack : CraftTweakerMC.getIngredient((IIngredient)ingredientInput).func_193365_a()) {
                recipes.add(new PurificationRecipe(new AdvancedMachineInput(stack, gas), output));
            }
            CrafttweakerIntegration.LATE_ADDITIONS.add(new AddMekanismRecipe<AdvancedMachineInput, ItemStackOutput, PurificationRecipe>(NAME, RecipeHandler.Recipe.PURIFICATION_CHAMBER, recipes));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient itemOutput, @Optional IIngredient itemInput, @Optional IIngredient gasInput) {
        if (IngredientHelper.checkNotNull(NAME, itemOutput)) {
            CrafttweakerIntegration.LATE_REMOVALS.add(new RemoveMekanismRecipe<AdvancedMachineInput, ItemStackOutput, PurificationRecipe>(NAME, RecipeHandler.Recipe.PURIFICATION_CHAMBER, new IngredientWrapper(itemOutput), new IngredientWrapper(itemInput, gasInput)));
        }
    }

    @ZenMethod
    public static void removeAllRecipes() {
        CrafttweakerIntegration.LATE_REMOVALS.add(new RemoveAllMekanismRecipe<AdvancedMachineInput, ItemStackOutput, PurificationRecipe>(NAME, RecipeHandler.Recipe.PURIFICATION_CHAMBER));
    }
}

