/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.Chunk3D;
import mekanism.api.Coord4D;
import mekanism.api.util.BlockInfo;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;

public class ThreadMinerSearch
extends Thread {
    private TileEntityDigitalMiner tileEntity;
    public State state = State.IDLE;
    private Map<Chunk3D, BitSet> oresToMine = new HashMap<Chunk3D, BitSet>();
    private Map<Integer, MinerFilter> replaceMap = new HashMap<Integer, MinerFilter>();
    private Map<BlockInfo, MinerFilter> acceptedItems = new HashMap<BlockInfo, MinerFilter>();
    public int found = 0;

    public ThreadMinerSearch(TileEntityDigitalMiner tile) {
        this.tileEntity = tile;
    }

    @Override
    public void run() {
        this.state = State.SEARCHING;
        if (!this.tileEntity.inverse && this.tileEntity.filters.isEmpty()) {
            this.state = State.FINISHED;
            return;
        }
        Coord4D coord = this.tileEntity.getStartingCoord();
        int diameter = this.tileEntity.getDiameter();
        int size = this.tileEntity.getTotalSize();
        BlockInfo info = new BlockInfo(null, 0);
        BlockPos minerPos = this.tileEntity.func_174877_v();
        World world = this.tileEntity.func_145831_w();
        for (int i = 0; i < size; ++i) {
            BlockPos testPos;
            if (this.tileEntity.func_145837_r()) {
                return;
            }
            int x = coord.x + i % diameter;
            int z = coord.z + i / diameter % diameter;
            int y = coord.y + i / diameter / diameter;
            if (minerPos.func_177958_n() == x && minerPos.func_177956_o() == y && minerPos.func_177952_p() == z || !world.func_175667_e(testPos = new BlockPos(x, y, z)) || world.func_175625_s(testPos) instanceof TileEntityBoundingBlock) continue;
            IBlockState state = world.func_180495_p(testPos);
            info.block = state.func_177230_c();
            info.meta = state.func_177230_c().func_176201_c(state);
            if (info.block == null || info.block instanceof BlockLiquid || info.block instanceof IFluidBlock || info.block.isAir(state, (IBlockAccess)world, testPos) || !(state.func_185887_b(world, testPos) >= 0.0f)) continue;
            MinerFilter filterFound = null;
            if (this.acceptedItems.containsKey(info)) {
                filterFound = this.acceptedItems.get(info);
            } else {
                ItemStack stack = new ItemStack(info.block, 1, info.meta);
                if (this.tileEntity.isReplaceStack(stack)) continue;
                for (MinerFilter filter : this.tileEntity.filters) {
                    if (!filter.canFilter(stack)) continue;
                    filterFound = filter;
                    break;
                }
                this.acceptedItems.put(info, filterFound);
            }
            if (this.tileEntity.inverse != (filterFound == null)) continue;
            this.set(i, new Coord4D(x, y, z, world.field_73011_w.getDimension()));
            this.replaceMap.put(i, filterFound);
            ++this.found;
        }
        this.state = State.FINISHED;
        this.tileEntity.oresToMine = this.oresToMine;
        this.tileEntity.replaceMap = this.replaceMap;
        MekanismUtils.saveChunk(this.tileEntity);
    }

    public void set(int i, Coord4D location) {
        Chunk3D chunk = new Chunk3D(location);
        this.oresToMine.computeIfAbsent(chunk, k -> new BitSet());
        this.oresToMine.get(chunk).set(i);
    }

    public void reset() {
        this.state = State.IDLE;
    }

    public static enum State {
        IDLE("Not ready"),
        SEARCHING("Searching"),
        PAUSED("Paused"),
        FINISHED("Ready");

        public String desc;

        private State(String s) {
            this.desc = s;
        }
    }
}

