/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.soul;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.fluid.FluidWrapper;
import com.enderio.core.common.fluid.SmartTankFluidHandler;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.fluid.SmartTankFluidMachineHandler;
import crazypants.enderio.base.machine.baselegacy.AbstractPoweredTaskEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.soul.ISoulBinderRecipe;
import crazypants.enderio.base.xp.ExperienceContainer;
import crazypants.enderio.base.xp.IHaveExperience;
import crazypants.enderio.base.xp.PacketExperienceContainer;
import crazypants.enderio.base.xp.XpUtil;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.config.config.SoulBinderConfig;
import crazypants.enderio.machines.network.PacketHandler;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public class TileSoulBinder
extends AbstractPoweredTaskEntity
implements IHaveExperience,
ITankAccess,
IPaintable.IPaintableTileEntity {
    @Store
    @Nonnull
    private final ExperienceContainer xpCont = new ExperienceContainer(){

        @Override
        public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
            return super.drain(from, Math.min(XpUtil.experienceToLiquid(TileSoulBinder.this.getExcessXP()), maxDrain), doDrain);
        }

        @Override
        public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
            int max = XpUtil.experienceToLiquid(TileSoulBinder.this.getXPRequired());
            if (resource == null || max <= 0) {
                return 0;
            }
            if (max < resource.amount) {
                FluidStack copy = resource.copy();
                copy.amount = max;
                return super.fill(from, copy, doFill);
            }
            return super.fill(from, resource, doFill);
        }
    };
    private boolean wasWorking = false;
    private SmartTankFluidHandler smartTankFluidHandler;

    public TileSoulBinder() {
        super(new SlotDefinition(2, 2, 1), CapacitorKey.SOUL_BINDER_POWER_INTAKE, CapacitorKey.SOUL_BINDER_POWER_BUFFER, CapacitorKey.SOUL_BINDER_POWER_USE);
        this.xpCont.setTileEntity((TileEntity)this);
        this.addICap(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facingIn -> this.getSmartTankFluidHandler().get(facingIn));
    }

    @Override
    @Nonnull
    public ExperienceContainer getContainer() {
        return this.xpCont;
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return "soulbinder";
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    @Override
    public int getInventoryStackLimit(int slot) {
        return this.getSlotDefinition().isOutputSlot(slot) ? 64 : super.getInventoryStackLimit(slot);
    }

    @Override
    protected boolean processTasks(boolean redstoneChecksPassed) {
        if (this.xpCont.isDirty()) {
            PacketHandler.sendToAllAround((IMessage)new PacketExperienceContainer((TileEntity)this), (TileEntity)this);
            this.xpCont.setDirty(false);
        }
        if (this.isActive()) {
            PacketHandler.INSTANCE.sendToAllAround(this.getProgressPacket(), (TileEntity)this);
        }
        return super.processTasks(redstoneChecksPassed);
    }

    @Override
    protected IMachineRecipe canStartNextTask(long nextSeed) {
        IMachineRecipe recipe = super.canStartNextTask(nextSeed);
        if (recipe == null) {
            return null;
        }
        int xpRequired = ((ISoulBinderRecipe)((Object)recipe)).getExperienceRequired();
        if (this.xpCont.getExperienceTotal() >= xpRequired) {
            return recipe;
        }
        return null;
    }

    public boolean needsXP() {
        return this.getXPRequired() > 0;
    }

    private int getXPRequired() {
        if (this.currentTask != null) {
            return 0;
        }
        IMachineRecipe nextRecipe = this.getNextRecipe();
        if (!(nextRecipe instanceof ISoulBinderRecipe)) {
            return 0;
        }
        return ((ISoulBinderRecipe)((Object)nextRecipe)).getExperienceRequired() - this.getContainer().getExperienceTotal();
    }

    public int getCurrentlyRequiredLevel() {
        if (this.currentTask != null) {
            return -1;
        }
        IMachineRecipe nextRecipe = this.getNextRecipe();
        if (!(nextRecipe instanceof ISoulBinderRecipe)) {
            return -1;
        }
        return ((ISoulBinderRecipe)((Object)nextRecipe)).getExperienceLevelsRequired();
    }

    @Override
    protected boolean startNextTask(@Nonnull IMachineRecipe nextRecipe, long nextSeed) {
        int xpRequired = ((ISoulBinderRecipe)((Object)nextRecipe)).getExperienceRequired();
        if (this.xpCont.getExperienceTotal() < xpRequired) {
            return false;
        }
        if (super.startNextTask(nextRecipe, nextSeed)) {
            this.xpCont.drain(null, XpUtil.experienceToLiquid(xpRequired), true);
            this.forceUpdatePlayers();
            return true;
        }
        return false;
    }

    @Override
    public boolean isMachineItemValidForSlot(int slot, @Nonnull ItemStack item) {
        int otherSlot;
        if (!this.slotDefinition.isInputSlot(slot)) {
            return false;
        }
        MachineRecipeInput newInput = new MachineRecipeInput(slot, item);
        int n = otherSlot = slot == 0 ? 1 : 0;
        if (Prep.isInvalid(this.getStackInSlot(otherSlot))) {
            NNList<IMachineRecipe> recipes = MachineRecipeRegistry.instance.getRecipesForInput(RecipeLevel.IGNORE, this.getMachineName(), newInput);
            if (recipes.isEmpty()) {
                return false;
            }
            for (IMachineRecipe rec : recipes) {
                if (rec == null || !rec.isValidInput(RecipeLevel.IGNORE, newInput)) continue;
                return true;
            }
        } else {
            NNList inputs = new NNList((Object[])new MachineRecipeInput[]{newInput, new MachineRecipeInput(otherSlot, this.getStackInSlot(otherSlot))});
            return MachineRecipeRegistry.instance.getRecipeForInputs(RecipeLevel.IGNORE, this.getMachineName(), (NNList<MachineRecipeInput>)inputs) != null;
        }
        return false;
    }

    @Override
    protected boolean doPull(@Nullable EnumFacing dir) {
        if (super.doPull(dir)) {
            return true;
        }
        int req = this.getXPRequired();
        if (dir != null && req > 0 && FluidWrapper.transfer((IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (FluidTank)this.xpCont, (int)Math.min(XpUtil.experienceToLiquid(req), (Integer)SoulBinderConfig.soulFluidInputRate.get())) > 0) {
            this.setTanksDirty();
            return true;
        }
        return false;
    }

    @Override
    protected boolean doPush(@Nullable EnumFacing dir) {
        if (super.doPush(dir)) {
            return true;
        }
        int maxAmount = Math.min(XpUtil.experienceToLiquid(this.getExcessXP()), (Integer)SoulBinderConfig.soulFluidOutputRate.get());
        if (dir != null && maxAmount > 0 && FluidWrapper.transfer((FluidTank)this.xpCont, (IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (int)maxAmount) > 0) {
            this.setTanksDirty();
            return true;
        }
        return false;
    }

    private int getExcessXP() {
        IMachineRecipe nextRecipe;
        if (this.currentTask == null && (nextRecipe = this.getNextRecipe()) instanceof ISoulBinderRecipe) {
            return Math.max(0, this.getContainer().getExperienceTotal() - ((ISoulBinderRecipe)((Object)nextRecipe)).getExperienceRequired());
        }
        return this.getContainer().getExperienceTotal();
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        return this.xpCont;
    }

    @Nonnull
    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.xpCont};
    }

    public void setTanksDirty() {
        this.xpCont.setDirty(true);
    }

    public boolean isWorking() {
        return this.currentTask == null ? false : this.currentTask.getProgress() >= 0.0f;
    }

    @Override
    protected void updateEntityClient() {
        super.updateEntityClient();
        if (this.wasWorking != this.isWorking()) {
            this.wasWorking = this.isWorking();
            this.updateBlock();
        }
    }

    @Override
    public ResourceLocation getSound() {
        return new ResourceLocation("enderio", "machine.soulbinder");
    }

    @Override
    public float getPitch() {
        return MathHelper.func_76131_a((float)(0.75f + (float)CapacitorKey.SOUL_BINDER_SOUND_PITCH.get(this.getCapacitorData()) * 0.05f + this.random.nextFloat() * 0.08f - 0.04f), (float)0.7f, (float)1.05f);
    }

    protected SmartTankFluidHandler getSmartTankFluidHandler() {
        if (this.smartTankFluidHandler == null) {
            this.smartTankFluidHandler = new SmartTankFluidMachineHandler(this, new IFluidHandler[]{this.xpCont});
        }
        return this.smartTankFluidHandler;
    }
}

