/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.niard;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.machines.machine.niard.TileNiard;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketNiardTank
extends MessageTileEntity<TileNiard> {
    private NBTTagCompound tag;

    public PacketNiardTank() {
    }

    public PacketNiardTank(@Nonnull TileNiard tile) {
        super((TileEntity)tile);
        this.tag = tile.getInputTank().writeToNBT(new NBTTagCompound());
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<PacketNiardTank, IMessage> {
        public IMessage onMessage(PacketNiardTank message, MessageContext ctx) {
            EntityPlayer player = EnderIO.proxy.getClientPlayer();
            TileNiard tile = (TileNiard)message.getTileEntity(player.field_70170_p);
            if (tile != null) {
                tile.getInputTank().readFromNBT(message.tag);
            }
            return null;
        }
    }
}

