/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractCrafting;
import crazypants.enderio.base.config.recipes.xml.ItemIntegerAmount;
import crazypants.enderio.base.config.recipes.xml.ItemOptional;
import crazypants.enderio.base.recipe.IRecipeInput;
import crazypants.enderio.base.recipe.ThingsRecipeInput;
import crazypants.enderio.base.recipe.alloysmelter.AlloyRecipeManager;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Alloying
extends AbstractCrafting {
    private float exp = 0.0f;
    private int energy;
    private final NNList<ItemIntegerAmount> input = new NNList();
    private boolean needsDeduping = false;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (this.input.isEmpty()) {
                throw new InvalidRecipeConfigException("Missing <input>");
            }
            if (this.input.size() > 3) {
                throw new InvalidRecipeConfigException("Too many <input>s");
            }
            if (this.exp < 0.0f) {
                throw new InvalidRecipeConfigException("Invalid negative value for 'exp'");
            }
            if (this.exp > 1.0f) {
                throw new InvalidRecipeConfigException("Invalid value for 'exp', above 100%");
            }
            if (this.energy <= 0) {
                throw new InvalidRecipeConfigException("Invalid low value for 'energy'");
            }
            NNList.NNIterator itr = this.input.fastIterator();
            while (this.valid && itr.hasNext()) {
                this.valid = this.valid && ((ItemIntegerAmount)itr.next()).isValid();
            }
            if (this.valid && this.input.size() >= 2) {
                NNList stacks0 = ((ItemIntegerAmount)this.input.get(0)).getThing().getItemStacks();
                NNList stacks1 = ((ItemIntegerAmount)this.input.get(1)).getThing().getItemStacks();
                if (((ItemIntegerAmount)this.input.get(0)).isSame((ItemOptional)this.input.get(1))) {
                    this.needsDeduping = true;
                    if (stacks0.size() == 1) {
                        this.valid = false;
                    }
                }
                if (this.input.size() == 3) {
                    if (((ItemIntegerAmount)this.input.get(0)).isSame((ItemOptional)this.input.get(2))) {
                        this.needsDeduping = true;
                        if (stacks0.size() == 1) {
                            this.valid = false;
                        }
                        if (((ItemIntegerAmount)this.input.get(1)).isSame((ItemOptional)this.input.get(2)) && stacks1.size() <= 2) {
                            this.valid = false;
                        }
                    } else if (((ItemIntegerAmount)this.input.get(1)).isSame((ItemOptional)this.input.get(2))) {
                        this.needsDeduping = true;
                        if (stacks1.size() == 1) {
                            this.valid = false;
                        }
                    }
                }
            }
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <alloying>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        super.enforceValidity();
        NNList.NNIterator itr = this.input.fastIterator();
        while (itr.hasNext()) {
            ((ItemIntegerAmount)itr.next()).enforceValidity();
        }
    }

    @Override
    public void register(@Nonnull String recipeName) {
        if (this.isValid() && this.isActive()) {
            NNList inputStacks = new NNList();
            NNList.NNIterator itr = this.input.fastIterator();
            while (itr.hasNext()) {
                ItemIntegerAmount item = (ItemIntegerAmount)itr.next();
                inputStacks.add((Object)new ThingsRecipeInput(item.getThing()).setCount(item.getAmount()));
            }
            AlloyRecipeManager.getInstance().addRecipe(this.needsDeduping, (NNList<IRecipeInput>)inputStacks, this.getOutput().getItemStack(), this.energy, this.exp);
        }
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("exp".equals(name)) {
            this.exp = Float.parseFloat(value);
            return true;
        }
        if ("energy".equals(name)) {
            this.energy = Integer.parseInt(value);
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("input".equals(name)) {
            this.input.add(factory.read(new ItemIntegerAmount().setAllowDelaying(false), startElement));
            return true;
        }
        return super.setElement(factory, name, startElement);
    }
}

