/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.meteor;

import WayofTime.bloodmagic.meteor.Meteor;
import WayofTime.bloodmagic.meteor.MeteorComponent;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MeteorRegistry {
    public static Map<ItemStack, Meteor> meteorMap = Maps.newHashMap();

    public static void registerMeteor(ItemStack stack, Meteor holder) {
        if (!stack.func_190926_b()) {
            meteorMap.put(stack, holder);
        }
    }

    public static void registerMeteor(ItemStack stack, List<MeteorComponent> componentList, float explosionStrength, int radius) {
        Meteor holder = new Meteor(stack, componentList, explosionStrength, radius);
        MeteorRegistry.registerMeteor(stack, holder);
    }

    @Nullable
    public static Meteor getMeteorForItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        for (Map.Entry<ItemStack, Meteor> entry : meteorMap.entrySet()) {
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void generateMeteorForItem(ItemStack stack, World world, BlockPos pos, IBlockState fillerBlock, double radiusModifier, double explosionModifier, double fillerChance) {
        Meteor meteor = MeteorRegistry.getMeteorForItem(stack);
        if (meteor != null) {
            meteor.generateMeteor(world, pos, fillerBlock, radiusModifier, explosionModifier, fillerChance);
        }
    }
}

