/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour;

import WayofTime.bloodmagic.livingArmour.ILivingArmour;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public abstract class LivingArmourUpgrade {
    public static String chatBase = "chat.bloodmagic.livingArmour.upgrade.";
    public static String tooltipBase = "tooltip.bloodmagic.livingArmour.upgrade.";
    protected int level = 0;

    public LivingArmourUpgrade(int level) {
        this.level = Math.min(level, this.getMaxTier() - 1);
    }

    public double getAdditionalDamageOnHit(double damage, EntityPlayer wearer, EntityLivingBase hitEntity, ItemStack weapon) {
        return 0.0;
    }

    public double getKnockbackOnHit(EntityPlayer wearer, EntityLivingBase hitEntity, ItemStack weapon) {
        return 0.0;
    }

    public double getArmourProtection(EntityLivingBase wearer, DamageSource source) {
        return 0.0;
    }

    public int getUpgradeLevel() {
        return this.level;
    }

    public abstract String getUniqueIdentifier();

    public abstract String getTranslationKey();

    public abstract int getMaxTier();

    public abstract int getCostOfUpgrade();

    public void onTick(World world, EntityPlayer player, ILivingArmour livingArmour) {
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers() {
        return HashMultimap.create();
    }

    public double getMiningSpeedModifier(EntityPlayer player) {
        return 1.0;
    }

    public abstract void writeToNBT(NBTTagCompound var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    public int getRunicShielding() {
        return 0;
    }

    public boolean runOnClient() {
        return false;
    }

    public boolean isDowngrade() {
        return false;
    }
}

