/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.soul;

import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.item.ItemEnum;
import WayofTime.bloodmagic.item.types.ISubItem;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.soul.IDemonWill;
import WayofTime.bloodmagic.util.helper.NBTHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMonsterSoul
extends ItemEnum.Variant<WillType>
implements IDemonWill {
    public ItemMonsterSoul() {
        super(WillType.class, "monster_soul");
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (!stack.func_77942_o()) {
            return;
        }
        tooltip.add(TextHelper.localize("tooltip.bloodmagic.will", this.getWill(this.getType(stack), stack)));
        super.func_77624_a(stack, world, tooltip, flag);
    }

    @Override
    public EnumDemonWillType getType(ItemStack stack) {
        return EnumDemonWillType.values()[stack.func_77952_i() % 5];
    }

    @Override
    public double getWill(EnumDemonWillType type, ItemStack soulStack) {
        if (type != this.getType(soulStack)) {
            return 0.0;
        }
        NBTHelper.checkNBT(soulStack);
        NBTTagCompound tag = soulStack.func_77978_p();
        return tag.func_74769_h("souls");
    }

    @Override
    public void setWill(EnumDemonWillType type, ItemStack soulStack, double souls) {
        NBTHelper.checkNBT(soulStack);
        NBTTagCompound tag = soulStack.func_77978_p();
        soulStack.func_77964_b(type.ordinal());
        tag.func_74780_a("souls", souls);
    }

    @Override
    public double drainWill(EnumDemonWillType type, ItemStack soulStack, double drainAmount) {
        double souls = this.getWill(type, soulStack);
        double soulsDrained = Math.min(drainAmount, souls);
        this.setWill(type, soulStack, souls - soulsDrained);
        return soulsDrained;
    }

    @Override
    public ItemStack createWill(int meta, double number) {
        ItemStack soulStack = new ItemStack((Item)this, 1, meta % 5);
        this.setWill(this.getType(soulStack), soulStack, number);
        return soulStack;
    }

    @Override
    public double getWill(ItemStack willStack) {
        return this.getWill(EnumDemonWillType.DEFAULT, willStack);
    }

    @Override
    public void setWill(ItemStack willStack, double will) {
        this.setWill(EnumDemonWillType.DEFAULT, willStack, will);
    }

    @Override
    public double drainWill(ItemStack willStack, double drainAmount) {
        return this.drainWill(EnumDemonWillType.DEFAULT, willStack, drainAmount);
    }

    public static enum WillType implements ISubItem
    {
        RAW,
        CORROSIVE,
        DESTRUCTIVE,
        VENGEFUL,
        STEADFAST;


        @Override
        @Nonnull
        public String getInternalName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        @Nonnull
        public ItemStack getStack(int count) {
            return new ItemStack(RegistrarBloodMagicItems.MONSTER_SOUL, count, this.ordinal());
        }
    }
}

