/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.routing;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.item.inventory.ItemInventory;
import WayofTime.bloodmagic.item.routing.IItemFilterProvider;
import WayofTime.bloodmagic.routing.DefaultItemFilter;
import WayofTime.bloodmagic.routing.IItemFilter;
import WayofTime.bloodmagic.routing.IgnoreNBTItemFilter;
import WayofTime.bloodmagic.routing.ModIdItemFilter;
import WayofTime.bloodmagic.routing.OreDictItemFilter;
import WayofTime.bloodmagic.routing.TestItemFilter;
import WayofTime.bloodmagic.util.GhostItemHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class ItemRouterFilter
extends Item
implements IItemFilterProvider,
IVariantProvider {
    public static String[] names = new String[]{"exact", "ignoreNBT", "modItems", "oreDict"};

    public ItemRouterFilter() {
        this.func_77655_b("bloodmagic.itemFilter.");
        this.func_77627_a(true);
        this.func_77637_a(BloodMagic.TAB_BM);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + names[stack.func_77952_i()];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        for (int i = 0; i < names.length; ++i) {
            list.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(TextHelper.localize("tooltip.bloodmagic.itemFilter." + names[stack.func_77952_i()], new Object[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }

    @Override
    public IItemFilter getInputItemFilter(ItemStack filterStack, TileEntity tile, IItemHandler handler) {
        IItemFilter testFilter = new TestItemFilter();
        switch (filterStack.func_77960_j()) {
            case 0: {
                testFilter = new TestItemFilter();
                break;
            }
            case 1: {
                testFilter = new IgnoreNBTItemFilter();
                break;
            }
            case 2: {
                testFilter = new ModIdItemFilter();
                break;
            }
            case 3: {
                testFilter = new OreDictItemFilter();
                break;
            }
            default: {
                testFilter = new DefaultItemFilter();
            }
        }
        ArrayList<ItemStack> filteredList = new ArrayList<ItemStack>();
        ItemInventory inv = new ItemInventory(filterStack, 9, "");
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            ItemStack ghostStack = GhostItemHelper.getStackFromGhost(stack);
            filteredList.add(ghostStack);
        }
        testFilter.initializeFilter(filteredList, tile, handler, false);
        return testFilter;
    }

    @Override
    public IItemFilter getOutputItemFilter(ItemStack filterStack, TileEntity tile, IItemHandler handler) {
        IItemFilter testFilter;
        switch (filterStack.func_77960_j()) {
            case 0: {
                testFilter = new TestItemFilter();
                break;
            }
            case 1: {
                testFilter = new IgnoreNBTItemFilter();
                break;
            }
            case 2: {
                testFilter = new ModIdItemFilter();
                break;
            }
            case 3: {
                testFilter = new OreDictItemFilter();
                break;
            }
            default: {
                testFilter = new DefaultItemFilter();
            }
        }
        ArrayList<ItemStack> filteredList = new ArrayList<ItemStack>();
        ItemInventory inv = new ItemInventory(filterStack, 9, "");
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            ItemStack ghostStack = GhostItemHelper.getStackFromGhost(stack);
            if (ghostStack.func_190926_b()) {
                ghostStack.func_190920_e(Integer.MAX_VALUE);
            }
            filteredList.add(ghostStack);
        }
        testFilter.initializeFilter(filteredList, tile, handler, true);
        return testFilter;
    }

    @Override
    public void gatherVariants(@Nonnull Int2ObjectMap<String> variants) {
        variants.put(0, (Object)"type=exact");
        variants.put(1, (Object)"type=ignorenbt");
        variants.put(2, (Object)"type=moditems");
        variants.put(3, (Object)"type=oredict");
    }

    @Override
    public ItemStack getContainedStackForItem(ItemStack filterStack, ItemStack keyStack) {
        ItemStack copyStack = keyStack.func_77946_l();
        GhostItemHelper.setItemGhostAmount(copyStack, 0);
        copyStack.func_190920_e(1);
        return copyStack;
    }
}

