/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.core.data.Binding;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.event.BoundToolEvent;
import WayofTime.bloodmagic.iface.IActivatable;
import WayofTime.bloodmagic.iface.IBindable;
import WayofTime.bloodmagic.util.Utils;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemBoundTool
extends ItemTool
implements IBindable,
IActivatable {
    public final int chargeTime = 30;
    protected final String tooltipBase;
    private final String name;
    public Map<ItemStack, Boolean> heldDownMap = new HashMap<ItemStack, Boolean>();
    public Map<ItemStack, Integer> heldDownCountMap = new HashMap<ItemStack, Integer>();

    public ItemBoundTool(String name, float damage, Set<Block> effectiveBlocks) {
        super(damage, 1.0f, RegistrarBloodMagicItems.BOUND_TOOL_MATERIAL, effectiveBlocks);
        this.func_77655_b("bloodmagic.bound." + name);
        this.func_77637_a(BloodMagic.TAB_BM);
        this.setHarvestLevel(name, 4);
        this.name = name;
        this.tooltipBase = "tooltip.bloodmagic.bound." + name + ".";
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return this.getActivated(stack) ? this.field_77862_b.func_77998_b() : 1.0f;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        subItems.add((Object)Utils.setUnbreakable(new ItemStack((Item)this)));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        Binding binding = this.getBinding(stack);
        if (binding == null) {
            this.setActivatedState(stack, false);
            return;
        }
        if (entity instanceof EntityPlayer && this.getActivated(stack) && isSelected && this.getBeingHeldDown(stack) && stack == ((EntityPlayer)entity).func_184607_cu()) {
            EntityPlayer player = (EntityPlayer)entity;
            this.setHeldDownCount(stack, Math.min(player.func_184605_cv(), 30));
        } else if (!isSelected) {
            this.setBeingHeldDown(stack, false);
        }
        if (entity instanceof EntityPlayer && this.getActivated(stack) && world.func_82737_E() % 80L == 0L) {
            NetworkHelper.getSoulNetwork(binding).syphonAndDamage((EntityPlayer)entity, SoulTicket.item(stack, world, entity, 20));
        }
    }

    protected int getHeldDownCount(ItemStack stack) {
        if (!this.heldDownCountMap.containsKey(stack)) {
            return 0;
        }
        return this.heldDownCountMap.get(stack);
    }

    protected void setHeldDownCount(ItemStack stack, int count) {
        this.heldDownCountMap.put(stack, count);
    }

    protected boolean getBeingHeldDown(ItemStack stack) {
        if (!this.heldDownMap.containsKey(stack)) {
            return false;
        }
        return this.heldDownMap.get(stack);
    }

    protected void setBeingHeldDown(ItemStack stack, boolean heldDown) {
        this.heldDownMap.put(stack, heldDown);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            this.setActivatedState(stack, !this.getActivated(stack));
        }
        if (!player.func_70093_af() && this.getActivated(stack)) {
            BoundToolEvent.Charge event = new BoundToolEvent.Charge(player, stack);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)event.result);
            }
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        EntityPlayer player;
        if (entityLiving instanceof EntityPlayer && !(player = (EntityPlayer)entityLiving).func_70093_af() && this.getActivated(stack)) {
            int i = this.func_77626_a(stack) - timeLeft;
            BoundToolEvent.Release event = new BoundToolEvent.Release(player, stack, i);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            i = event.charge;
            this.onBoundRelease(stack, worldIn, player, Math.min(i, 30));
            this.setBeingHeldDown(stack, false);
        }
    }

    protected void onBoundRelease(ItemStack stack, World world, EntityPlayer player, int charge) {
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77619_b() {
        return 50;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (TextHelper.canTranslate(this.tooltipBase + "desc")) {
            tooltip.add(TextHelper.localizeEffect(this.tooltipBase + "desc", new Object[0]));
        }
        tooltip.add(TextHelper.localize("tooltip.bloodmagic." + (this.getActivated(stack) ? "activated" : "deactivated"), new Object[0]));
        if (!stack.func_77942_o()) {
            return;
        }
        Binding binding = this.getBinding(stack);
        if (binding != null) {
            tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.currentOwner", binding.getOwnerName()));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)this.name);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        return ArrayListMultimap.create();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getActivated(stack) && this.getBeingHeldDown(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)(-Math.min(this.getHeldDownCount(stack), 30)) / 30.0 + 1.0;
    }

    public String getTooltipBase() {
        return this.tooltipBase;
    }

    public String getName() {
        return this.name;
    }

    public Map<ItemStack, Boolean> getHeldDownMap() {
        return this.heldDownMap;
    }

    public Map<ItemStack, Integer> getHeldDownCountMap() {
        return this.heldDownCountMap;
    }

    public int getChargeTime() {
        return 30;
    }

    protected void sharedHarvest(ItemStack stack, World world, EntityPlayer player, BlockPos blockPos, IBlockState blockState, boolean silkTouch, int fortuneLvl) {
        float strengthVsBlock;
        if (blockState.func_185887_b(world, blockPos) != -1.0f && (strengthVsBlock = this.func_150893_a(stack, blockState)) > 1.1f && world.canMineBlockBody(player, blockPos)) {
            if (!player.func_184812_l_()) {
                if (silkTouch && blockState.func_177230_c().canSilkHarvest(world, blockPos, world.func_180495_p(blockPos), player)) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(Item.func_150898_a((Block)blockState.func_177230_c())));
                } else {
                    NonNullList itemDrops = NonNullList.func_191196_a();
                    blockState.func_177230_c().getDrops(itemDrops, (IBlockAccess)world, blockPos, world.func_180495_p(blockPos), fortuneLvl);
                    for (ItemStack stacks : itemDrops) {
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stacks);
                    }
                }
            }
            blockState.func_177230_c().removedByPlayer(world.func_180495_p(blockPos), world, blockPos, player, false);
        }
    }
}

