/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.entity.mob;

import WayofTime.bloodmagic.entity.ai.EntityAIAttackStealthMelee;
import WayofTime.bloodmagic.entity.ai.EntityAIStealthRetreat;
import WayofTime.bloodmagic.entity.ai.EntityAIStealthTowardsTarget;
import WayofTime.bloodmagic.entity.mob.EntityAspectedDemonBase;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityCorruptedChicken
extends EntityAspectedDemonBase {
    private final int attackPriority = 3;
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta = 1.0f;
    public int timeUntilNextEgg;
    public int attackStateMachine = 0;
    private EntityAIAttackStealthMelee aiAttackOnCollide;

    public EntityCorruptedChicken(World world) {
        this(world, EnumDemonWillType.DEFAULT);
    }

    public EntityCorruptedChicken(World world, EnumDemonWillType type) {
        super(world);
        this.func_70105_a(0.4f, 0.7f);
        this.timeUntilNextEgg = this.field_70146_Z.nextInt(600) + 600;
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.setType(type);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIStealthTowardsTarget(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIStealthRetreat(this, 6.0f, 1.4, 1.4));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, (Predicate)new EntityAspectedDemonBase.TeamAttackPredicate(this, this)));
    }

    @Override
    public void setCombatTask() {
        if (this.aiAttackOnCollide != null) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        }
        this.aiAttackOnCollide = new EntityAIAttackStealthMelee(this, this.getBaseSprintModifier(this.getType()), false);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiAttackOnCollide);
    }

    public void cloak() {
        this.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 50, 0, false, false));
    }

    @Override
    public double getBaseHP(EnumDemonWillType type) {
        return super.getBaseHP(type) * 0.5;
    }

    @Override
    public double getBaseMeleeDamage(EnumDemonWillType type) {
        return super.getBaseMeleeDamage(type) * 2.5;
    }

    @Override
    public double getBaseSpeed(EnumDemonWillType type) {
        return super.getBaseSpeed(type);
    }

    @Override
    public double getBaseSprintModifier(EnumDemonWillType type) {
        return super.getBaseSprintModifier(type);
    }

    @Override
    public double getBaseKnockbackResist(EnumDemonWillType type) {
        return super.getBaseKnockbackResist(type);
    }

    public float func_70047_e() {
        return this.field_70131_O;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        this.wingRotation += this.wingRotDelta * 2.0f;
        if (!this.func_130014_f_().field_72995_K && !this.func_70631_g_() && --this.timeUntilNextEgg <= 0) {
            this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_145779_a(Items.field_151110_aK, 1);
            this.timeUntilNextEgg = this.field_70146_Z.nextInt(600) + 600;
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187660_W;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.field_187666_Z;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187663_X;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.5f;
    }

    @Override
    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("EggLayTime")) {
            this.timeUntilNextEgg = compound.func_74762_e("EggLayTime");
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("EggLayTime", this.timeUntilNextEgg);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        float f = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f1 = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f2 = 0.1f;
        float f3 = 0.0f;
        passenger.func_70107_b(this.field_70165_t + (double)(0.1f * f), this.field_70163_u + (double)(this.field_70131_O * 0.5f) + passenger.func_70033_W() + 0.0, this.field_70161_v - (double)(0.1f * f1));
        if (passenger instanceof EntityLivingBase) {
            ((EntityLivingBase)passenger).field_70761_aq = this.field_70761_aq;
        }
    }
}

